#pragma compile(UPX, True)
#pragma compile(Compression, 7)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, Update Utility)
#pragma compile(FileDescription, Updater for software developer)
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)
#pragma compile(Sign, G.Sandler)

#include <GUIConstantsEx.au3>
#include '..\AppCheckUpdates.au3'

$hParent 								= _GetCmdLine('Parent', 0, HWnd)
$iSilent 								= _GetCmdLine('Silent', 0, Number)
$iBackup 								= _GetCmdLine('Backup', 1, Number)
$sName 									= _GetCmdLine('Name', 'YourApp', String)
$sVer 									= _GetCmdLine('Ver', '1.0', String)
$sLang 									= _GetCmdLine('Lang', 'English', String)

$sConfig_File						 	= @ScriptDir & '\Config.ini'
				
$APPCU_7ZIP								= @TempDir & '\7z.exe'
$APPCU_DAT_URL 							= IniRead($sConfig_File, 'Update', 'Dat URL', '')
$APPCU_APP_NAME 						= $sName
$APPCU_APP_VER 							= $sVer

$APPCU_MSGS[$APPCU_MSG_ATNTN] 			= IniRead($sConfig_File, $sLang, 'MSG_ATNTN', 'Attention')
$APPCU_MSGS[$APPCU_MSG_ERR]				= IniRead($sConfig_File, $sLang, 'MSG_ERR', 'Error')
$APPCU_MSGS[$APPCU_MSG_UPDCHCK]			= IniRead($sConfig_File, $sLang, 'MSG_UPDCHCK', 'Update check')
$APPCU_MSGS[$APPCU_MSG_CHCKUPDERR]		= IniRead($sConfig_File, $sLang, 'MSG_CHCKUPDERR', 'There was an error (%i) checking the update, please contact with software developer.')
$APPCU_MSGS[$APPCU_MSG_NEWVER]			= IniRead($sConfig_File, $sLang, 'MSG_NEWVER', 'There is new version available (%s).\n\nChange Log:\n\n%s\n\nWould you like to download the update?')
$APPCU_MSGS[$APPCU_MSG_DNLDUPDERR]		= IniRead($sConfig_File, $sLang, 'MSG_DNLDUPDERR', 'There was an error (%i) downloading the update, please contact with software developer.')
$APPCU_MSGS[$APPCU_MSG_EXTRCTUPDERR]	= IniRead($sConfig_File, $sLang, 'MSG_EXTRCTUPDERR', 'There was an error (%i) to extract archive, please contact with software developer.')
$APPCU_MSGS[$APPCU_MSG_USNGNEWSTVER]	= IniRead($sConfig_File, $sLang, 'MSG_USNGNEWSTVER', 'You are using the newest version of this software (%s).')
$APPCU_MSGS[$APPCU_MSG_CHCKINETCNCT]	= IniRead($sConfig_File, $sLang, 'MSG_CHCKINETCNCT', 'Please check your internet connection and try again.')
$APPCU_MSGS[$APPCU_MSG_DNLDNG]			= IniRead($sConfig_File, $sLang, 'MSG_DNLDNG', 'Downloading [%s]')
$APPCU_MSGS[$APPCU_MSG_CMPLTD]			= IniRead($sConfig_File, $sLang, 'MSG_CMPLTD', 'Completed: %s%%')

If $CmdLine[0] = 0 Then
	MsgBox(48, @ScriptName, _
		'This utility should be executed with the following command line parameters:' & @CRLF & @CRLF & _
		'/Parent=Parent window handle to attach messages' & @CRLF & _
		'/Silent=...' & @CRLF & _
			@TAB & '0 - Check update and display all messages' & @CRLF & _
			@TAB & '1 - Check update quitly (prompt only when update available)' & @CRLF & _
			@TAB & '2 - Check update quitly (without any prompt!)' & @CRLF & _
		'/Backup=0 - Do not backup, 1 - Backup (all files in current dir)' & @CRLF & @CRLF & _
		'/Name=YourAppName' & @CRLF & _
		'/Ver=YourAppVersion' & @CRLF & @CRLF & _
		'/Lang=Language to use in "Update ChangeLog[ Language]" in update.dat file and for translations in config file' _
		)
	
	Exit
EndIf

FileInstall('..\Resources\7z.exe', $APPCU_7ZIP, 1)

$iPID = _AppCheckUpdates($hParent, $iSilent, $iBackup, $sLang)
ProcessWaitClose($iPID)
$iError = Number(StdoutRead($iPID))

ConsoleWrite($iError & @LF)
ConsoleWriteError($iError)

FileDelete($APPCU_7ZIP)

Func _GetCmdLine($sCmd, $sDefault = '', $hConvertFunc = String)
	Local $sRet = StringRegExpReplace($CmdLineRaw, '(?s).*/' & $sCmd & '="([^"]*)".*', '\1')
	
	If Not @extended Or $sRet = $CmdLineRaw Then
		Return SetError(1, 0, $sDefault)
	EndIf
	
	Return $hConvertFunc($sRet)
EndFunc
